﻿using System;
using System.Collections.Generic;
using HIPS.Web.Components.Cache;
using HIPS.Web.Model.Common;

namespace HIPS.Web.ModelInterface.Common
{
    public class CachedSettingsRepository : ISettingsRepository
    {
        private ISettingsRepository ReferenceRepository { get; set; }
        private ICacheProvider CacheProvider { get; set; }
        private readonly string CacheKeyFormat;

        public CachedSettingsRepository(ISettingsRepository referenceRepository, ICacheProvider cacheProvider, string cacheKeyPrefix = "")
        {
            ReferenceRepository = referenceRepository;
            CacheProvider = cacheProvider;
            CacheKeyFormat = cacheKeyPrefix + ".CachedSettingsRepository.{0}";
        }

        public List<Setting> GetSettings()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetSettings"),
                () => ReferenceRepository.GetSettings());
        }

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            if (ReferenceRepository != null)
            {
                ReferenceRepository.Dispose();
                ReferenceRepository = null;
            }
        }
    }
}
